/*
 * Decompiled with CFR 0.152.
 */
package TechMap;

import LogicOptimization.EMinTermsProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TechMapper {
    private EMinTermsProcessor techMap;
    public String inpExpressionWithBraces;
    private FileReader gatesLibFileName;
    public ArrayList<ArrayList<String>> externalInvertersList = new ArrayList();
    public ArrayList<ArrayList<String>> internalInvertersList = new ArrayList();
    public ArrayList<ArrayList<String>> externalNorGatesList = new ArrayList();
    public ArrayList<ArrayList<String>> semiExternalNorGatesList = new ArrayList();
    public ArrayList<ArrayList<String>> internalNorGatesList = new ArrayList();
    public ArrayList<ArrayList<String>> minTermsGatesListAInv = new ArrayList();
    public ArrayList<ArrayList<String>> minTermsGatesListBInv = new ArrayList();
    public ArrayList<ArrayList<String>> minTermsGatesListCInv = new ArrayList();
    public ArrayList<ArrayList<String>> minTermsGatesListBInvOPGlobal = new ArrayList();
    public ArrayList<ArrayList<String>> norGate1 = new ArrayList();
    public ArrayList<ArrayList<String>> sequenceOfGatesList = new ArrayList();
    public ArrayList<ArrayList<String>> sequenceOfAllGatesList = new ArrayList();
    public ArrayList<ArrayList<String>> intermNorGatesListInExp = new ArrayList();
    public int sizeOfListWithInv;
    public int sizeOfListWithOuterInput;
    public int sizeOfListWithLeftInput;
    public int sizeOfListWithRightInput;
    public int sizeOfListWithInvAndGates;
    private int circuitCount = 1;

    public TechMapper(String inpExpression) {
        this.techMap = new EMinTermsProcessor(null, 0.0, null);
        this.inpExpressionWithBraces = this.techMap.replaceBracesWithTags(inpExpression);
    }

    public String readGatesLibFile() throws IOException {
        String fullFile = "";
        this.gatesLibFileName = new FileReader("../GatesLib.txt");
        BufferedReader gatesLibraryFile = new BufferedReader(this.gatesLibFileName);
        String read = "";
        String line = gatesLibraryFile.readLine();
        while (line != null) {
            read = String.valueOf(read) + line;
            line = gatesLibraryFile.readLine();
        }
        fullFile = read;
        return fullFile;
    }

    public void parseGateLibComp(String inputGatesLib) {
        String extInv = inputGatesLib.substring(inputGatesLib.indexOf("<Ext-Inverters>") + 15, inputGatesLib.indexOf("</Ext-Inverters>"));
        extInv = extInv.substring(extInv.indexOf("Out") + 3);
        String intInv = inputGatesLib.substring(inputGatesLib.indexOf("<Int-Inverters>") + 15, inputGatesLib.indexOf("</Int-Inverters>"));
        String extNorGates = inputGatesLib.substring(inputGatesLib.indexOf("<Ext-NorGates>") + 14, inputGatesLib.indexOf("</Ext-NorGates>"));
        extNorGates = extNorGates.substring(extNorGates.indexOf("Out") + 3);
        String semiExtNorGates = inputGatesLib.substring(inputGatesLib.indexOf("<Semi-Ext-NorGates>") + 19, inputGatesLib.indexOf("</Semi-Ext-NorGates>"));
        String intNorGates = inputGatesLib.substring(inputGatesLib.indexOf("<Int-NorGates>") + 14, inputGatesLib.indexOf("</Int-NorGates>"));
        this.externalInvertersList = this.generateListOfGates(extInv);
        this.internalInvertersList = this.generateListOfGates(intInv);
        this.externalNorGatesList = this.generateListOfGates(extNorGates);
        this.semiExternalNorGatesList = this.generateListOfGates(semiExtNorGates);
        this.internalNorGatesList = this.generateListOfGates(intNorGates);
    }

    private ArrayList<ArrayList<String>> generateListOfGates(String parsedInputString) {
        ArrayList<ArrayList<String>> inputList = new ArrayList<ArrayList<String>>();
        String[] array = parsedInputString.split(" END ");
        int i = 0;
        while (i < array.length) {
            ArrayList<String> intermList = new ArrayList<String>();
            intermList.addAll(Arrays.asList(array[i].split("\t")));
            inputList.add(i, intermList);
            ++i;
        }
        return inputList;
    }

    public void generateTreeExpression() {
        String inputExpression;
        String intermExp = inputExpression = this.inpExpressionWithBraces;
        String SOP = "SOP1";
        String EOP = "EOP1";
        ArrayList minTerms = new ArrayList();
        int Cnt = this.cntSop1Terms(inputExpression, SOP);
        int i = 1;
        while (i <= Cnt) {
            this.extractNestedSOPelements(intermExp, SOP, EOP);
            SOP = "SOP1";
            EOP = "EOP1";
            intermExp = inputExpression.substring(inputExpression.indexOf(EOP) + EOP.length());
            ++i;
        }
    }

    private void extractNestedSOPelements(String intermExp, String SOP, String EOP) {
        ArrayList<String> minTerms = new ArrayList<String>();
        ArrayList<ArrayList<String>> rxList = new ArrayList<ArrayList<String>>();
        ArrayList inputRXListWOSop = new ArrayList();
        intermExp = intermExp.substring(intermExp.indexOf(SOP) + 4, intermExp.indexOf(EOP));
        Pattern pattern = Pattern.compile("(?m)(.*?)\\+(SOP.*?$)");
        Matcher sopMinTerms = pattern.matcher(intermExp);
        if (sopMinTerms.find()) {
            minTerms.add(0, sopMinTerms.group(1));
            minTerms.add(1, sopMinTerms.group(2));
            SOP = "SOP";
            EOP = "EOP";
            int i = 0;
            while (i < minTerms.size()) {
                if (minTerms.get(i).contains(SOP)) {
                    this.extractNestedSOPelements(minTerms.get(i), SOP, EOP);
                } else {
                    rxList = this.gotoList(minTerms.get(i));
                    this.sizeOfListWithOuterInput = this.sequenceOfAllGatesList.size();
                }
                ++i;
            }
        } else {
            String[] intermArray = intermExp.split("\\+", 2);
            int j = 0;
            while (j < intermArray.length) {
                minTerms.add(j, intermArray[j]);
                ++j;
            }
            this.intermNorGatesListInExp = this.gateAssignment(minTerms);
        }
        if (!rxList.isEmpty()) {
            this.finalOutputMultiple(rxList);
            ArrayList<ArrayList<String>> checkInvList = new ArrayList<ArrayList<String>>();
            ArrayList invList = new ArrayList();
            checkInvList.addAll(this.sequenceOfAllGatesList.subList(0, this.sizeOfListWithInv));
            String opOfOuterGateInput = "";
            String opOfInnerLeftInput = "";
            String opOfInnerRightInput = "";
            String input1ofInnerNorGate = "";
            String input2ofInnerNorGate = "";
            String outputOfInnerNorGate = "";
            String input1ofOuterNorGate = "";
            String input2ofOuterNorGate = "";
            int cnt = 1;
            ArrayList<ArrayList<String>> doubleCheck = new ArrayList<ArrayList<String>>();
            int h = 0;
            while (h < this.sizeOfListWithOuterInput) {
                opOfOuterGateInput = this.sequenceOfAllGatesList.get(h).get(2);
                int i = 0;
                while (i < this.sizeOfListWithLeftInput - this.sizeOfListWithOuterInput) {
                    opOfInnerLeftInput = this.sequenceOfAllGatesList.get(i + this.sizeOfListWithOuterInput).get(2);
                    int j = 0;
                    while (j < this.sizeOfListWithRightInput - this.sizeOfListWithLeftInput) {
                        opOfInnerRightInput = this.sequenceOfAllGatesList.get(j + this.sizeOfListWithLeftInput).get(2);
                        if (!opOfInnerLeftInput.equals(opOfInnerRightInput)) {
                            int k = 0;
                            while (k < this.sizeOfListWithInvAndGates - this.sizeOfListWithRightInput) {
                                input1ofInnerNorGate = this.sequenceOfAllGatesList.get(k + this.sizeOfListWithRightInput).get(0);
                                input2ofInnerNorGate = this.sequenceOfAllGatesList.get(k + this.sizeOfListWithRightInput).get(1);
                                if ((opOfInnerLeftInput.equals(input1ofInnerNorGate) || opOfInnerLeftInput.equals(input2ofInnerNorGate)) && (opOfInnerRightInput.equals(input1ofInnerNorGate) || opOfInnerRightInput.equals(input2ofInnerNorGate))) {
                                    outputOfInnerNorGate = this.sequenceOfAllGatesList.get(k + this.sizeOfListWithRightInput).get(2);
                                    int l = 0;
                                    while (l < this.sequenceOfAllGatesList.size() - this.sizeOfListWithInvAndGates) {
                                        input1ofOuterNorGate = this.sequenceOfAllGatesList.get(l + this.sizeOfListWithInvAndGates).get(0);
                                        input2ofOuterNorGate = this.sequenceOfAllGatesList.get(l + this.sizeOfListWithInvAndGates).get(1);
                                        if ((outputOfInnerNorGate.equals(input1ofOuterNorGate) || outputOfInnerNorGate.equals(input2ofOuterNorGate)) && (opOfOuterGateInput.equals(input1ofOuterNorGate) || opOfOuterGateInput.equals(input2ofOuterNorGate))) {
                                            ArrayList<ArrayList<String>> sequenceOfGates = new ArrayList<ArrayList<String>>();
                                            ArrayList<String> diagram2 = new ArrayList<String>();
                                            if (!this.sequenceOfAllGatesList.get(i + this.sizeOfListWithOuterInput).get(0).equals(" ")) {
                                                sequenceOfGates.add(this.sequenceOfAllGatesList.get(i + this.sizeOfListWithOuterInput));
                                            }
                                            if (!this.sequenceOfAllGatesList.get(j + this.sizeOfListWithLeftInput).get(0).equals(" ")) {
                                                sequenceOfGates.add(this.sequenceOfAllGatesList.get(j + this.sizeOfListWithLeftInput));
                                            }
                                            sequenceOfGates.add(this.sequenceOfAllGatesList.get(this.sizeOfListWithRightInput + k));
                                            sequenceOfGates.add(this.sequenceOfAllGatesList.get(this.sizeOfListWithInvAndGates + l));
                                            if (!this.sequenceOfAllGatesList.get(h).get(0).equals(" ")) {
                                                diagram2 = this.sequenceOfAllGatesList.get(h);
                                                this.constructMultipleDiagram(sequenceOfGates, cnt, diagram2);
                                            } else {
                                                diagram2.add(0, "null");
                                                this.constructMultipleDiagram(sequenceOfGates, cnt, diagram2);
                                            }
                                            ++cnt;
                                            doubleCheck.add(this.sequenceOfAllGatesList.get(this.sizeOfListWithInvAndGates + l));
                                        }
                                        ++l;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                ++h;
            }
        }
    }

    private void constructDiagram() {
        String diagram = "";
        String protein = "";
        System.out.println("\n************************************** Genetic Circuit **************************************");
        int i = 0;
        while (i < this.sequenceOfGatesList.size()) {
            String in1;
            if (this.sequenceOfGatesList.get(i).get(0).contains("'")) {
                in1 = this.sequenceOfGatesList.get(i).get(1);
                protein = this.sequenceOfGatesList.get(i).get(2);
                protein = protein.replace("P", "");
                diagram = String.valueOf(diagram) + in1 + "-> (" + protein + ")----|";
            } else if (this.sequenceOfGatesList.get(i).get(0).equals("PTac") || this.sequenceOfGatesList.get(i).get(0).equals("PTet") || this.sequenceOfGatesList.get(i).get(0).equals("PBad")) {
                in1 = this.sequenceOfGatesList.get(i).get(1);
                String in2 = this.sequenceOfGatesList.get(i).get(0);
                protein = this.sequenceOfGatesList.get(i).get(2);
                protein = protein.replace("P", "");
                diagram = String.valueOf(diagram) + in1 + "-> " + in2 + "-> (" + protein + ")----|";
            }
            ++i;
        }
        diagram = String.valueOf(diagram) + "P".concat(protein) + "-> " + "(YFP)";
        System.out.println("\n" + diagram);
        System.out.println("\n*********************************************************************************************");
    }

    private void constructMultipleDiagram(ArrayList<ArrayList<String>> sequenceOfGates, int cnt, ArrayList<String> input1ofOuterNorGate) {
        String diagram = "";
        String diagram2 = "";
        boolean idxD2 = false;
        boolean lengthD2 = false;
        String protein = "";
        String in1 = "";
        String in2 = "";
        int i = 0;
        while (i < sequenceOfGates.size()) {
            if (sequenceOfGates.get(i).get(0).contains("'")) {
                in1 = sequenceOfGates.get(i).get(1);
                protein = sequenceOfGates.get(i).get(2);
                protein = protein.replaceFirst("P", "");
                diagram = String.valueOf(diagram) + in1 + "-> (" + protein + ")----|";
            } else if (sequenceOfGates.get(i).get(0).equals("PTac") || sequenceOfGates.get(i).get(0).equals("PTet") || sequenceOfGates.get(i).get(0).equals("PBad")) {
                in1 = sequenceOfGates.get(i).get(1);
                in2 = sequenceOfGates.get(i).get(0);
                protein = sequenceOfGates.get(i).get(2);
                protein = protein.replaceFirst("P", "");
                diagram = String.valueOf(diagram) + in1 + "-> " + in2 + "-> (" + protein + ")----|";
            } else {
                if (sequenceOfGates.get(i - 1).get(2).equals(sequenceOfGates.get(i).get(0))) {
                    in1 = sequenceOfGates.get(i).get(0);
                    in2 = sequenceOfGates.get(i).get(1);
                } else if (sequenceOfGates.get(i - 1).get(2).equals(sequenceOfGates.get(i).get(1))) {
                    in1 = sequenceOfGates.get(i).get(1);
                    in2 = sequenceOfGates.get(i).get(0);
                }
                protein = sequenceOfGates.get(i).get(2);
                protein = protein.replaceFirst("P", "");
                diagram = String.valueOf(diagram) + in1 + "-> " + in2 + "-> (" + protein + ")----|";
            }
            ++i;
        }
        diagram = String.valueOf(diagram) + "P".concat(protein) + "-> " + "(YFP)";
        if (!input1ofOuterNorGate.get(0).equals("null")) {
            in1 = input1ofOuterNorGate.get(1);
            protein = input1ofOuterNorGate.get(2);
            protein = protein.replaceFirst("P", "");
            diagram2 = String.valueOf(diagram2) + in1 + "-> (" + protein + ")";
        }
        this.checkCircuitDiagram(cnt, diagram, diagram2, input1ofOuterNorGate);
    }

    private void checkCircuitDiagram(int cnt, String diagram, String diagram2, ArrayList<String> input1ofOuterNorGate) {
        boolean BadSolution;
        int i;
        String firstProt = diagram.substring(diagram.indexOf("(") + 1, diagram.indexOf(")"));
        String firstProm = diagram.substring(diagram.indexOf("|") + 2, diagram.indexOf("->", diagram.indexOf("|")));
        String desiredProm = "P" + firstProt;
        String diagram3 = "";
        if (!firstProt.equals(firstProm)) {
            diagram3 = diagram.substring(0, diagram.indexOf(")") + 1);
            diagram = diagram.substring(diagram.indexOf("|") + 1);
            int idx = diagram.indexOf(desiredProm);
            int length = idx - diagram3.length();
            i = 0;
            while (i < length) {
                diagram3 = String.valueOf(diagram3) + "-";
                ++i;
            }
            diagram3 = diagram3.concat("--T");
        }
        if (!diagram2.isEmpty()) {
            int idxD2 = diagram.indexOf(input1ofOuterNorGate.get(2));
            int lengthD2 = idxD2 - diagram2.length();
            i = 0;
            while (i < lengthD2) {
                diagram2 = String.valueOf(diagram2) + "-";
                ++i;
            }
            diagram2 = diagram2.concat("--T");
        }
        if (!(BadSolution = this.filterBadSolutions(diagram, diagram2, diagram3))) {
            System.out.println("\n************************************** Genetic Circuit " + this.circuitCount + " **************************************");
            System.out.println("\n" + diagram);
            if (!diagram2.isEmpty()) {
                System.out.println(diagram2);
            }
            if (!diagram3.isEmpty()) {
                System.out.println(diagram3);
            }
            System.out.println("\n***********************************************************************************************");
            ++this.circuitCount;
        }
    }

    private boolean filterBadSolutions(String diagram, String diagram2, String diagram3) {
        int protInMainDiagSize;
        int protCnt = StringUtils.countMatches((CharSequence)diagram, "(");
        String intermDiagram = diagram;
        ArrayList<String> protInMainDiag = new ArrayList<String>();
        String protInDiag2 = "";
        String protInDiag3 = "";
        boolean badSolution = false;
        int i = 0;
        while (i < protCnt - 1) {
            String interm = intermDiagram.substring(intermDiagram.indexOf("("), intermDiagram.indexOf(")") + 1);
            protInMainDiag.add(i, interm);
            intermDiagram = intermDiagram.substring(intermDiagram.indexOf(")") + 1);
            ++i;
        }
        if (!diagram2.isEmpty()) {
            protInDiag2 = diagram2.substring(diagram2.indexOf("("), diagram2.indexOf(")") + 1);
        }
        if (!diagram3.isEmpty()) {
            protInDiag3 = diagram3.substring(diagram3.indexOf("("), diagram3.indexOf(")") + 1);
        }
        int protInDiagSubSize = protInMainDiagSize = protInMainDiag.size();
        if (protInMainDiag.contains(protInDiag2)) {
            badSolution = true;
        } else if (protInMainDiag.contains(protInDiag3)) {
            badSolution = true;
        } else {
            int i2 = 0;
            while (i2 < protInMainDiagSize) {
                int j = 1;
                while (j < protInDiagSubSize) {
                    badSolution = ((String)protInMainDiag.get(i2)).equals(protInMainDiag.get(i2 + j));
                    if (badSolution) {
                        i2 = protInMainDiagSize;
                        break;
                    }
                    if (j == protInDiagSubSize - 1) {
                        --protInDiagSubSize;
                        badSolution = false;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return badSolution;
    }

    private void finalOutputLevel(ArrayList<ArrayList<String>> norGateInputA) {
        ArrayList<ArrayList<String>> intermList = new ArrayList<ArrayList<String>>();
        if (norGateInputA.get(1).size() == 1 && (norGateInputA.get(1).get(0).contains("PTac") || norGateInputA.get(1).get(0).contains("PTet") || norGateInputA.get(1).get(0).contains("PBad"))) {
            if (norGateInputA.get(1).get(0).contains("PTac")) {
                intermList.addAll(this.semiExternalNorGatesList.subList(0, 5));
            } else if (norGateInputA.get(1).get(0).contains("PTet")) {
                intermList.addAll(this.semiExternalNorGatesList.subList(5, 12));
            } else if (norGateInputA.get(1).get(0).contains("PBad")) {
                intermList.addAll(this.semiExternalNorGatesList.subList(12, 16));
            }
            int i = 0;
            block0: while (i < this.intermNorGatesListInExp.size()) {
                int j = 0;
                while (j < intermList.size()) {
                    if (this.intermNorGatesListInExp.get(i).get(2).equals(((ArrayList)intermList.get(j)).get(1))) {
                        this.sequenceOfGatesList.add(this.intermNorGatesListInExp.get(i));
                        this.sequenceOfGatesList.add((ArrayList)intermList.get(j));
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void finalOutputMultiple(ArrayList<ArrayList<String>> OuterNorGateInputA) {
        block18: {
            ArrayList<ArrayList<String>> addedGate;
            block17: {
                ArrayList<ArrayList<String>> intermList = new ArrayList<ArrayList<String>>();
                addedGate = new ArrayList<ArrayList<String>>();
                if (OuterNorGateInputA.size() != 1) break block17;
                if (!OuterNorGateInputA.get(0).get(2).contains("PTac") && !OuterNorGateInputA.get(0).get(2).contains("PTet") && !OuterNorGateInputA.get(0).get(2).contains("PBad")) break block18;
                if (OuterNorGateInputA.get(0).get(2).contains("PTac")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(0, 5));
                } else if (OuterNorGateInputA.get(0).get(2).contains("PTet")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(5, 12));
                } else if (OuterNorGateInputA.get(0).get(2).contains("PBad")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(12, 16));
                }
                this.sequenceOfAllGatesList.addAll(this.intermNorGatesListInExp);
                this.sizeOfListWithInvAndGates = this.sequenceOfAllGatesList.size();
                int i = 0;
                while (i < this.intermNorGatesListInExp.size()) {
                    int j = 0;
                    while (j < intermList.size()) {
                        if (this.intermNorGatesListInExp.get(i).get(2).equals(((ArrayList)intermList.get(j)).get(1)) && !((String)((ArrayList)intermList.get(j)).get(2)).equals(this.intermNorGatesListInExp.get(i).get(1))) {
                            this.sequenceOfAllGatesList.add((ArrayList)intermList.get(j));
                        }
                        ++j;
                    }
                    ++i;
                }
                break block18;
            }
            if (OuterNorGateInputA.size() > 1) {
                String opOfOuterInput = "";
                String opOfIntermNorGateInExp = "";
                this.sequenceOfAllGatesList.addAll(this.intermNorGatesListInExp);
                this.sizeOfListWithInvAndGates = this.sequenceOfAllGatesList.size();
                int i = 0;
                while (i < this.intermNorGatesListInExp.size()) {
                    int j = 0;
                    while (j < OuterNorGateInputA.size()) {
                        opOfOuterInput = OuterNorGateInputA.get(j).get(2);
                        if (!opOfOuterInput.equals(opOfIntermNorGateInExp = this.intermNorGatesListInExp.get(i).get(2))) {
                            int k = 0;
                            while (k < this.internalNorGatesList.size()) {
                                if (!(!opOfOuterInput.equals(this.internalNorGatesList.get(k).get(0)) && !opOfOuterInput.equals(this.internalNorGatesList.get(k).get(1)) || !opOfIntermNorGateInExp.equals(this.internalNorGatesList.get(k).get(0)) && !opOfIntermNorGateInExp.equals(this.internalNorGatesList.get(k).get(1)) || this.internalNorGatesList.get(k).get(2).equals(this.intermNorGatesListInExp.get(i).get(0)) || this.internalNorGatesList.get(k).get(2).equals(this.intermNorGatesListInExp.get(i).get(1)) || opOfOuterInput.equals(this.intermNorGatesListInExp.get(i).get(0)) || opOfOuterInput.equals(this.intermNorGatesListInExp.get(i).get(1)) || addedGate.contains(this.internalNorGatesList.get(k)))) {
                                    this.sequenceOfAllGatesList.add(this.internalNorGatesList.get(k));
                                    addedGate.add(this.internalNorGatesList.get(k));
                                }
                                ++k;
                            }
                        } else {
                            int m = 0;
                            while (m < this.internalInvertersList.size()) {
                                if (opOfOuterInput.equals(this.internalInvertersList.get(0))) {
                                    this.sequenceOfAllGatesList.add(this.internalInvertersList.get(m));
                                }
                                ++m;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private ArrayList<ArrayList<String>> gotoList(String minterm) {
        ArrayList<ArrayList<String>> outputList = new ArrayList<ArrayList<String>>();
        ArrayList type = new ArrayList();
        ArrayList element = new ArrayList();
        if (minterm.contains("'")) {
            if (minterm.contentEquals("a'")) {
                outputList.addAll(0, this.externalInvertersList.subList(0, 4));
                this.sequenceOfAllGatesList.addAll(outputList);
            } else if (minterm.contentEquals("b'")) {
                outputList.addAll(0, this.externalInvertersList.subList(4, 6));
                this.sequenceOfAllGatesList.addAll(outputList);
            } else if (minterm.contentEquals("c'")) {
                outputList.addAll(0, this.externalInvertersList.subList(6, 9));
                this.sequenceOfAllGatesList.addAll(outputList);
            }
        } else {
            outputList.add(0, type);
            ((ArrayList)outputList.get(0)).add(0, "null");
            outputList.get(0).add(1, "null");
            outputList.get(0).add(2, "null");
            if (minterm.contains("a")) {
                outputList.get(0).set(0, " ");
                outputList.get(0).set(1, "a");
                outputList.get(0).set(2, "PTac");
                this.sequenceOfAllGatesList.addAll(outputList);
            } else if (minterm.contains("b")) {
                outputList.get(0).set(0, " ");
                outputList.get(0).set(1, "b");
                outputList.get(0).set(2, "PTet");
                this.sequenceOfAllGatesList.addAll(outputList);
            } else if (minterm.contains("c")) {
                outputList.get(0).set(0, " ");
                outputList.get(0).set(1, "c");
                outputList.get(0).set(2, "PBad");
                this.sequenceOfAllGatesList.addAll(outputList);
            }
        }
        return outputList;
    }

    private ArrayList<ArrayList<String>> gateAssignment(ArrayList<String> minTerms) {
        ArrayList<ArrayList<String>> listOfNorGates;
        block41: {
            ArrayList<ArrayList<String>> intermList;
            ArrayList<Object> rxListR;
            ArrayList<Object> rxListL;
            String minTermR;
            String minTermL;
            block42: {
                String[] norGateType;
                block40: {
                    String[] intermMintermArray = new String[]{"", ""};
                    minTermL = minTerms.get(0);
                    minTermR = minTerms.get(1);
                    ArrayList<String> mintermArray = minTerms;
                    rxListL = new ArrayList();
                    rxListR = new ArrayList();
                    listOfNorGates = new ArrayList<ArrayList<String>>();
                    intermList = new ArrayList<ArrayList<String>>();
                    norGateType = new String[]{"", ""};
                    if (minTermL.contains("'")) {
                        rxListL = this.gotoList(minTermL);
                        this.sizeOfListWithLeftInput = this.sequenceOfAllGatesList.size();
                        norGateType[0] = "Int";
                    } else {
                        rxListL = this.gotoList(minTermL);
                        this.sizeOfListWithLeftInput = this.sequenceOfAllGatesList.size();
                        norGateType[0] = "Ext";
                    }
                    if (minTermR.contains("'")) {
                        rxListR = this.gotoList(minTermR);
                        this.sizeOfListWithRightInput = this.sequenceOfAllGatesList.size();
                        norGateType[1] = "Int";
                    } else {
                        rxListR = this.gotoList(minTermR);
                        this.sizeOfListWithRightInput = this.sequenceOfAllGatesList.size();
                        norGateType[1] = "Ext";
                    }
                    if (norGateType[0] != "Int" || norGateType[1] != "Int") break block40;
                    String gateInput1 = "";
                    String gateInput2 = "";
                    String leftT = "";
                    String rightT = "";
                    intermList.addAll(this.internalNorGatesList);
                    int leftTerm = 0;
                    while (leftTerm < rxListL.size()) {
                        int rightTerm = 0;
                        while (rightTerm < rxListR.size()) {
                            leftT = (String)((ArrayList)rxListL.get(leftTerm)).get(2);
                            if (!leftT.equals(rightT = (String)((ArrayList)rxListR.get(rightTerm)).get(2))) {
                                int searchIdx = 0;
                                while (searchIdx < intermList.size()) {
                                    gateInput1 = (String)((ArrayList)intermList.get(searchIdx)).get(0);
                                    gateInput2 = (String)((ArrayList)intermList.get(searchIdx)).get(1);
                                    if ((leftT.equals(gateInput1) || leftT.equals(gateInput2)) && (rightT.equals(gateInput1) || rightT.equals(gateInput2))) {
                                        listOfNorGates.add((ArrayList)intermList.get(searchIdx));
                                        intermList.remove(searchIdx);
                                    }
                                    ++searchIdx;
                                }
                            }
                            ++rightTerm;
                        }
                        ++leftTerm;
                    }
                    break block41;
                }
                if (norGateType[0] != "Ext" || norGateType[1] != "Ext") break block42;
                if (minTermL.contentEquals("a")) {
                    if (minTermR.contentEquals("b")) {
                        intermList.addAll(this.externalNorGatesList.subList(0, 5));
                    } else if (minTermR.contentEquals("c")) {
                        System.out.println("\nError: There are no gates available that can be integrated to implement the desired function.");
                    }
                }
                if (minTermL.contentEquals("b")) {
                    if (minTermR.contentEquals("a")) {
                        intermList.addAll(this.externalNorGatesList.subList(0, 5));
                    } else if (minTermR.contentEquals("c")) {
                        intermList.addAll(this.externalNorGatesList.subList(5, 8));
                    }
                }
                if (minTermL.contentEquals("c")) {
                    if (minTermR.contentEquals("a")) {
                        System.out.println("\nError: There are no gates available that can be integrated to implement the desired function.");
                    } else if (minTermR.contentEquals("b")) {
                        intermList.addAll(this.externalNorGatesList.subList(5, 8));
                    }
                }
                if (intermList.contains(null)) break block41;
                listOfNorGates.addAll(intermList);
                break block41;
            }
            if (minTermL.contains("'")) {
                if (((String)((ArrayList)rxListR.get(0)).get(2)).contains("PTac")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(0, 5));
                } else if (((String)((ArrayList)rxListR.get(0)).get(2)).contains("PTet")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(5, 12));
                } else if (((String)((ArrayList)rxListR.get(0)).get(2)).contains("PBad")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(12, 16));
                }
                int inv = 0;
                while (inv < rxListL.size()) {
                    int gates = 0;
                    while (gates < intermList.size()) {
                        String b;
                        String a = (String)((ArrayList)rxListL.get(inv)).get(2);
                        if (a.equals(b = (String)((ArrayList)intermList.get(gates)).get(1))) {
                            listOfNorGates.add((ArrayList)intermList.get(gates));
                        }
                        ++gates;
                    }
                    ++inv;
                }
            } else if (minTermR.contains("'")) {
                if (((String)((ArrayList)rxListL.get(0)).get(2)).contains("PTac")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(0, 5));
                } else if (((String)((ArrayList)rxListL.get(0)).get(2)).contains("PTet")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(5, 12));
                } else if (((String)((ArrayList)rxListL.get(0)).get(2)).contains("PBad")) {
                    intermList.addAll(this.semiExternalNorGatesList.subList(12, 16));
                }
                int inv = 0;
                while (inv < rxListR.size()) {
                    int gates = 0;
                    while (gates < intermList.size()) {
                        String b;
                        String a = (String)((ArrayList)rxListR.get(inv)).get(2);
                        if (a.equals(b = (String)((ArrayList)intermList.get(gates)).get(1))) {
                            listOfNorGates.add((ArrayList)intermList.get(gates));
                        }
                        ++gates;
                    }
                    ++inv;
                }
            }
        }
        return listOfNorGates;
    }

    private int cntSop1Terms(String inputExpression, String searchSOP) {
        int Cnt = 1;
        String[] array = inputExpression.split("\\+", 2);
        while (array[1].contains(searchSOP)) {
            inputExpression = array[1].substring(array[1].indexOf(searchSOP) + 4);
            array = inputExpression.split("\\+", 2);
            ++Cnt;
        }
        return Cnt;
    }
}

