/*
 * Decompiled with CFR 0.152.
 */
package LogicOptimization;

import LogicOptimization.DReduceExp;
import java.io.File;

public class CSaAlgo {
    private double tempCoeff;
    private double initTemp;
    private int timeToRun;
    private String inputExp;
    public String bestSolution;
    public int newCost = 0;

    public CSaAlgo(double tempCoeff, double initTemp, double timeToRun, String inputExpression) throws Exception {
        double currentTemp = 0.0;
        String currentSt = inputExpression;
        String nextSt = "";
        int prevCost = 0;
        int Cnt = 0;
        boolean forceExpand = false;
        File file = new File("../DebugLog.xls");
        DReduceExp REDUCE = new DReduceExp(file);
        long tStart = System.currentTimeMillis();
        double currentTime = 0.0;
        int loopCount = 0;
        while (currentTime <= timeToRun) {
            double acceptanceProb;
            initTemp = currentTemp = tempCoeff * initTemp;
            nextSt = REDUCE.performReduction(currentSt, loopCount);
            prevCost = REDUCE.costOfCurrentExpression;
            this.newCost = REDUCE.costOfNewExpression;
            if (this.newCost >= prevCost) {
                acceptanceProb = Math.exp((double)(-(this.newCost - prevCost)) / currentTemp);
                ++Cnt;
            } else {
                acceptanceProb = 1.0;
            }
            if (acceptanceProb > Math.random()) {
                currentSt = nextSt;
            }
            currentTime = this.getTime(tStart);
            ++loopCount;
        }
        this.bestSolution = currentSt;
    }

    private double getTime(long tStart) {
        long tEnd = System.currentTimeMillis();
        long tDelta = tEnd - tStart;
        double elapsedSeconds = (double)tDelta / 1000.0;
        return elapsedSeconds;
    }

    public String getBestSolution() {
        return this.bestSolution;
    }
}

