/*
 * Decompiled with CFR 0.152.
 */
package LogicOptimization;

import LogicOptimization.ALVJavaInterface;
import LogicOptimization.BCalculateCost;
import LogicOptimization.CSaAlgo;
import LogicOptimization.EMinTermsProcessor;
import LogicOptimization.NotNorConverter;
import TechMap.TechMapper;
import java.io.File;

public class Main {
    public static void main(String[] args) throws Exception {
        ALVJavaInterface inputInterface = new ALVJavaInterface();
        String newInputEq = Main.initLVJavaInterface(inputInterface);
        int initialCost = Main.initCalculateCost(newInputEq);
        double initTemp = ALVJavaInterface.initTemp;
        double tempCoeff = ALVJavaInterface.tempCoeff;
        double timeToRun = ALVJavaInterface.timeToRun;
        String bestSolution = Main.runSaAlgo(newInputEq, initTemp, tempCoeff, timeToRun);
        String outExp = "";
        String inputExp = bestSolution;
        EMinTermsProcessor processExpression = new EMinTermsProcessor("", 0.0, "");
        NotNorConverter convertExp = new NotNorConverter();
        String outputString = convertExp.convertIntoNotNorExp(inputExp);
        System.out.println("\nSynthesized Expression into NOT-NOR Form: " + outputString);
        ALVJavaInterface outputInterface = new ALVJavaInterface();
        String newOrigEq = Main.outputToLabVIEW(outputInterface, inputInterface, outputString);
        System.out.println("\nNew Expression with input proteins: " + newOrigEq);
        TechMapper mapGatesOnExpression = new TechMapper(outputString);
        String libFile = mapGatesOnExpression.readGatesLibFile();
        mapGatesOnExpression.parseGateLibComp(libFile);
        mapGatesOnExpression.generateTreeExpression();
    }

    private static void printGatesList(TechMapper mapGatesOnExpression) {
        System.out.println("\nList of External Inverters");
        System.out.println("----------------------------");
        int i = 0;
        while (i < mapGatesOnExpression.externalInvertersList.size()) {
            System.out.println(mapGatesOnExpression.externalInvertersList.get(i));
            ++i;
        }
        System.out.println("\nList of Internal Inverters");
        System.out.println("----------------------------");
        i = 0;
        while (i < mapGatesOnExpression.internalInvertersList.size()) {
            System.out.println(mapGatesOnExpression.internalInvertersList.get(i));
            ++i;
        }
        System.out.println("\nList of External Nor Gates");
        System.out.println("----------------------------");
        i = 0;
        while (i < mapGatesOnExpression.externalNorGatesList.size()) {
            System.out.println(mapGatesOnExpression.externalNorGatesList.get(i));
            ++i;
        }
        System.out.println("\nList of Semi External Nor Gates");
        System.out.println("---------------------------------");
        i = 0;
        while (i < mapGatesOnExpression.semiExternalNorGatesList.size()) {
            System.out.println(mapGatesOnExpression.semiExternalNorGatesList.get(i));
            ++i;
        }
        System.out.println("\nList of Internal Nor Gates");
        System.out.println("----------------------------");
        i = 0;
        while (i < mapGatesOnExpression.internalNorGatesList.size()) {
            System.out.println(mapGatesOnExpression.internalNorGatesList.get(i));
            ++i;
        }
    }

    private static String outputToLabVIEW(ALVJavaInterface outputInterface, ALVJavaInterface inputInterface, String outputString) {
        String[] newInputNames = inputInterface.getNewInputNames();
        String[] origInputNames = inputInterface.getOrigInputNames();
        String newOrigEq = outputInterface.replaceInputEqWithOrigNames(outputString, newInputNames, origInputNames);
        return newOrigEq;
    }

    public static String initLVJavaInterface(ALVJavaInterface inputInterface) {
        String[] inputProt = new String[]{"IPTG", "aTc", "Arabinose"};
        inputInterface.setOrigInputNames(inputProt);
        ALVJavaInterface.takeInputs();
        String newInputEq = inputInterface.replaceInputEqWithNewNames(inputInterface.replaceInputNames());
        return newInputEq;
    }

    public static int initCalculateCost(String inputEq) {
        BCalculateCost initialCost = new BCalculateCost(inputEq);
        int initCost = initialCost.getCost();
        System.out.println("Initial Cost: " + initCost);
        return initCost;
    }

    public static String runSaAlgo(String newInputEq, double initTemp, double tempCoeff, double timeToRun) throws Exception {
        String filePath = "";
        File writeFile = new File(filePath);
        CSaAlgo SimAnneal = new CSaAlgo(tempCoeff, initTemp, timeToRun, newInputEq);
        System.out.println("\nOptimized Expression: " + SimAnneal.getBestSolution());
        System.out.println("\nNew Cost: " + SimAnneal.newCost);
        return SimAnneal.getBestSolution();
    }
}

