/*
 * Decompiled with CFR 0.152.
 */
package LogicOptimization;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EMinTermsProcessor {
    public String inpExp;
    public double selRandomIdx;
    public String outExp;
    public String multiplier;
    public String resultString;
    public String multiplicand;
    public boolean ruleMatched;

    public EMinTermsProcessor(String inExp, double selRandomIdx, String outExp) {
        this.selRandomIdx = selRandomIdx;
        this.outExp = outExp;
    }

    public String expandMinTerms(String inpExp) {
        this.resultString = this.replaceBracesWithTags(inpExp);
        int selRandIdx = this.findSopIndices(this.resultString);
        if (selRandIdx != -1) {
            this.expandSOPTag(this.resultString, selRandIdx);
            int CntMinTerms = this.cntMinTermsInExpression(this.multiplicand);
            String[] currentMinTerms = new String[CntMinTerms];
            currentMinTerms = this.generateMinTermsArray(this.multiplicand, CntMinTerms);
            this.outExp = this.expandMinTermsArray(currentMinTerms);
        } else {
            this.outExp = inpExp;
        }
        return this.outExp;
    }

    public String replaceBracesWithTags(String inpExp) {
        this.resultString = inpExp;
        int braceCnt = 0;
        String braceTag = "";
        this.resultString = this.resultString.replaceAll(" ", "");
        int i = 0;
        while (i < this.resultString.length()) {
            String var;
            switch (var = this.resultString.substring(i, i + 1)) {
                case "(": {
                    braceTag = "SOP" + ++braceCnt;
                    this.resultString = this.resultString.replaceFirst("\\(", braceTag);
                    break;
                }
                case ")": {
                    braceTag = "EOP" + braceCnt;
                    --braceCnt;
                    this.resultString = this.resultString.replaceFirst("\\)", braceTag);
                }
            }
            ++i;
        }
        return this.resultString;
    }

    private int findSopIndices(String resultString) {
        int sopIdx = 0;
        int RandIdx = 0;
        int selIdx = -1;
        ArrayList<Integer> sopIndices = new ArrayList<Integer>();
        sopIdx = resultString.indexOf("SOP1");
        while (sopIdx != -1) {
            if (sopIdx != -1) {
                sopIndices.add(sopIdx);
            }
            sopIdx = resultString.indexOf("SOP1", sopIdx + 4);
        }
        if (!sopIndices.isEmpty() && !sopIndices.equals("-1")) {
            RandIdx = (int)Math.floor(Math.random() * (double)sopIndices.size());
            selIdx = (Integer)sopIndices.get(RandIdx);
        }
        return selIdx;
    }

    private void expandSOPTag(String resultString, int selIdx) {
        this.multiplier = resultString.substring(0, selIdx);
        this.multiplicand = resultString.substring(selIdx);
        this.multiplicand = this.multiplicand.substring(4, this.multiplicand.indexOf("EOP1"));
        this.multiplier = this.multiplier.substring(this.multiplier.lastIndexOf("+") + 1);
    }

    public int cntMinTermsInExpression(String expression) {
        String origMultiplicand = expression;
        String EOP = "EOP";
        int Idx = 0;
        int CntMinTerms = 0;
        Pattern pattern = Pattern.compile("(SOP)([0-9]+)");
        while (Idx != -1) {
            Idx = expression.indexOf("+");
            if (Idx != -1) {
                String[] splitMultiplicand = expression.split("\\+", 2);
                Matcher matcher = pattern.matcher(splitMultiplicand[0]);
                if (matcher.find()) {
                    Idx = splitMultiplicand[1].indexOf(EOP = EOP.concat(matcher.group(2)));
                    if (Idx != -1 && (expression = splitMultiplicand[1].substring(Idx + EOP.length())).contains("+") && !expression.startsWith("+")) {
                        expression = expression.substring(expression.indexOf("+"));
                    }
                    ++CntMinTerms;
                } else {
                    Idx = expression.indexOf("+");
                    if (!splitMultiplicand[0].isEmpty()) {
                        ++CntMinTerms;
                    }
                    expression = splitMultiplicand[1];
                }
                EOP = "EOP";
                continue;
            }
            if (expression.isEmpty() || expression.contentEquals("'")) continue;
            ++CntMinTerms;
        }
        return CntMinTerms;
    }

    public String[] generateMinTermsArray(String inputExp, int CntMinTerms) {
        String[] currentMinTerms = new String[CntMinTerms];
        String EOP = "EOP";
        String SOP = "SOP";
        String bar = "";
        boolean Idx = false;
        Pattern pattern = Pattern.compile("(SOP)([0-9]+)");
        int i = 0;
        while (i < CntMinTerms) {
            bar = "";
            String[] splitMultiplicand = inputExp.split("\\+", 2);
            Matcher matcher = pattern.matcher(splitMultiplicand[0]);
            if (matcher.find()) {
                SOP = "SOP" + matcher.group(2);
                splitMultiplicand[0] = splitMultiplicand[0].replaceFirst(SOP, "(");
                splitMultiplicand[0] = splitMultiplicand[0].replaceAll("(SOP)([0-9]+)", "(");
                splitMultiplicand[0] = splitMultiplicand[0].replaceAll("(EOP)([0-9]+)", ")");
                splitMultiplicand[0] = splitMultiplicand[0].replaceAll(" ", "");
                EOP = "EOP" + matcher.group(2);
                splitMultiplicand[1] = splitMultiplicand[1].replaceFirst(EOP, ")");
                bar = i != CntMinTerms - 1 ? splitMultiplicand[1].substring(splitMultiplicand[1].indexOf(")") + 1, splitMultiplicand[1].indexOf(")") + 2) : splitMultiplicand[1].substring(splitMultiplicand[1].indexOf(")") + 1);
                String[] splitMultiplicand2 = bar.contentEquals("'") ? splitMultiplicand[1].split("\\)'", 2) : splitMultiplicand[1].split("\\)", 2);
                splitMultiplicand2[0] = splitMultiplicand2[0].replaceAll("(SOP)([0-9]+)", "(");
                splitMultiplicand2[0] = splitMultiplicand2[0].replaceAll("(EOP)([0-9]+)", ")");
                splitMultiplicand2[0] = splitMultiplicand2[0].replaceAll(" ", "");
                int check = 32;
                if (!splitMultiplicand2[1].isEmpty()) {
                    check = splitMultiplicand2[1].charAt(0);
                }
                inputExp = check == 43 ? splitMultiplicand2[1].substring(1) : splitMultiplicand2[1];
                currentMinTerms[i] = bar.contentEquals("'") ? splitMultiplicand[0].concat("+").concat(splitMultiplicand2[0]).concat(")'") : splitMultiplicand[0].concat("+").concat(splitMultiplicand2[0]).concat(")");
            } else {
                currentMinTerms[i] = splitMultiplicand[0].isEmpty() ? splitMultiplicand[1] : splitMultiplicand[0];
                if (splitMultiplicand.length > 1) {
                    inputExp = splitMultiplicand[1];
                }
            }
            ++i;
        }
        return currentMinTerms;
    }

    public String expandMinTermsArray(String[] currentMinTerms) {
        String[] outputMinTerms = new String[currentMinTerms.length];
        int i = 0;
        while (i < currentMinTerms.length) {
            if (currentMinTerms[i].contains("1")) {
                currentMinTerms[i] = "";
            }
            outputMinTerms[i] = this.scanRules(this.multiplier.concat(currentMinTerms[i]));
            ++i;
        }
        String expandedMinTerms = this.minTermsToExpression(outputMinTerms);
        String searchExpression = this.multiplier.concat("SOP1").concat(this.multiplicand).concat("EOP1");
        String expandedExpression = this.resultString;
        expandedExpression = expandedExpression.replace(searchExpression, expandedMinTerms);
        expandedExpression = this.replaceTagsWithBraces(expandedExpression);
        return expandedExpression;
    }

    public String minTermsToExpression(String[] inputMinTerms) {
        String expandedMinterms = "";
        int i = 0;
        while (i < inputMinTerms.length) {
            expandedMinterms = inputMinTerms.length - i != 1 ? expandedMinterms.concat(inputMinTerms[i]).concat("+") : expandedMinterms.concat(inputMinTerms[i]).concat("");
            ++i;
        }
        return expandedMinterms;
    }

    public String replaceTagsWithBraces(String inputExpression) {
        String expandedExpression = inputExpression;
        if (expandedExpression != null) {
            expandedExpression = expandedExpression.replaceAll("(SOP)([0-9]+)", "(");
            expandedExpression = expandedExpression.replaceAll("(EOP)([0-9]+)", ")");
        }
        return expandedExpression;
    }

    public String scanRules(String inpExp) {
        String localInpExp;
        String ruleVariable = localInpExp = inpExp;
        String replacedRule = "";
        boolean ones = false;
        this.ruleMatched = false;
        if (!(ruleVariable = ruleVariable.replaceAll("1|\\+|0", "")).isEmpty()) {
            ruleVariable = ruleVariable.substring(0, 1);
        }
        if (localInpExp.contains("1")) {
            String[] breakAroundOne = localInpExp.split("1", 2);
            breakAroundOne[0] = breakAroundOne[0].replaceAll(" ", "");
            if (breakAroundOne[0].length() != 0) {
                breakAroundOne[0] = breakAroundOne[0].substring(breakAroundOne[0].length() - 1, breakAroundOne[0].length());
            }
            breakAroundOne[1] = breakAroundOne[1].replaceAll(" ", "");
            if (breakAroundOne[1].length() != 0) {
                breakAroundOne[1] = breakAroundOne[1].substring(0, 1);
            }
            ones = breakAroundOne[0].equals("+") || breakAroundOne[1].equals("+") || breakAroundOne[0].equals("") && breakAroundOne[1].equals("");
        }
        String[][] rulesForVariables = this.generateRulesforVariable(ruleVariable);
        if (ones) {
            replacedRule = "1";
            this.ruleMatched = true;
        } else {
            int row = 0;
            while (row < 17) {
                int col = 0;
                while (col < 2) {
                    if (col == 0) {
                        if (localInpExp.equals(rulesForVariables[row][col])) {
                            replacedRule = rulesForVariables[row][col + 1];
                            this.ruleMatched = true;
                            row = 18;
                            col = 3;
                            break;
                        }
                        replacedRule = localInpExp;
                        this.ruleMatched = false;
                    }
                    ++col;
                }
                ++row;
            }
        }
        return replacedRule;
    }

    public String[][] generateRulesforVariable(String ruleVariable) {
        String[][] standardRules = new String[][]{{"x+x", "x"}, {"x'+x'", "x'"}, {"x+1", "1"}, {"1+x", "1"}, {"x'+1", "1"}, {"1+x'", "1"}, {"x1", "x"}, {"1x", "x"}, {"x0", "0"}, {"0x", "0"}, {"x+0", "x"}, {"0+x", "x"}, {"x+x'", "1"}, {"x'+x", "1"}, {"xx'", "0"}, {"x'x", "0"}, {"xx", "x"}};
        String[][] rulesForVariables = new String[17][2];
        if (!ruleVariable.equals("")) {
            int row = 0;
            while (row < 16) {
                int col = 0;
                while (col < 2) {
                    rulesForVariables[row][col] = standardRules[row][col].replaceAll("x", ruleVariable);
                    ++col;
                }
                ++row;
            }
        }
        return rulesForVariables;
    }

    public ArrayList<String> arrangeLitInArray(String minTerm) {
        ArrayList<String> separateArrayOfLitInMt = new ArrayList<String>();
        String MtWithSopTag = "";
        String tempString = "";
        if (minTerm.contains("SOP1")) {
            MtWithSopTag = minTerm.substring(minTerm.indexOf("SOP1"), minTerm.indexOf("EOP1") + 4);
            tempString = minTerm.substring(minTerm.indexOf("SOP1") + 4, minTerm.indexOf("EOP1"));
            tempString = this.replaceTagsWithBraces(tempString);
            separateArrayOfLitInMt.add(tempString);
        } else {
            tempString = "";
        }
        String restOfMt = minTerm.replace(MtWithSopTag, "");
        separateArrayOfLitInMt = this.extractLiteralsFromMinTerms(separateArrayOfLitInMt, restOfMt);
        return separateArrayOfLitInMt;
    }

    public ArrayList<String> extractLiteralsFromMinTerms(ArrayList<String> separateArrayOfLitInMt, String restOfMt) {
        int i = 0;
        while (i < restOfMt.length()) {
            if (i + 1 != restOfMt.length()) {
                if (restOfMt.charAt(i + 1) == '\'') {
                    if (i + 2 == restOfMt.length()) {
                        separateArrayOfLitInMt.add(restOfMt.substring(i));
                    } else {
                        separateArrayOfLitInMt.add(restOfMt.substring(i, i + 2));
                    }
                } else if (restOfMt.charAt(i) != '\'') {
                    separateArrayOfLitInMt.add(restOfMt.substring(i, i + 1));
                }
            } else if (restOfMt.charAt(i) != '\'') {
                separateArrayOfLitInMt.add(restOfMt.substring(i));
            }
            ++i;
        }
        return separateArrayOfLitInMt;
    }

    public String[] splitStringIntoTwo(String inputString, String splitAroundString) {
        String[] splittedString = new String[]{"", ""};
        if (inputString.contains(splitAroundString)) {
            try {
                splittedString = inputString.split(splitAroundString, 2);
            }
            catch (Exception e) {
                splittedString = inputString.split("\\" + splitAroundString, 2);
            }
        } else {
            splittedString[0] = inputString;
            splittedString[1] = "";
        }
        return splittedString;
    }
}

