/*
 * Decompiled with CFR 0.152.
 */
package LogicOptimization;

import LogicOptimization.BCalculateCost;
import LogicOptimization.EMinTermsProcessor;
import LogicOptimization.FScanCommonLiterals;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class DReduceExp {
    public String inputExpression;
    public int loopCnt;
    public int varCnt;
    private EMinTermsProcessor processExpressionReduce;
    private FScanCommonLiterals processRandElements;
    public String newExpression;
    private String expressionToProcess;
    public String outputExpression;
    private int totalMinTerms;
    public int costOfCurrentExpression;
    public int costOfNewExpression;
    private boolean expand = false;
    private boolean forceExpand = false;
    private double expandProb = 0.6;
    private boolean manualSelComb = false;
    private String manualComb = "M2M3";
    private boolean createNewFile = true;
    public static File file;

    public DReduceExp(File file) throws IOException {
    }

    public String performReduction(String inputExpression, int loopCount) throws Exception {
        this.processExpressionReduce = new EMinTermsProcessor(inputExpression, 0.0, "");
        BCalculateCost currentCost = new BCalculateCost(inputExpression);
        this.costOfCurrentExpression = currentCost.getCost();
        this.expressionToProcess = inputExpression;
        if (this.forceExpand) {
            this.expressionToProcess = this.processExpressionReduce.expandMinTerms(inputExpression);
        } else if (Math.random() > this.expandProb) {
            this.expressionToProcess = this.processExpressionReduce.expandMinTerms(inputExpression);
            this.expand = true;
        } else {
            this.expressionToProcess = inputExpression;
            this.expand = false;
        }
        String resultString = this.processExpressionReduce.replaceBracesWithTags(this.expressionToProcess);
        this.totalMinTerms = this.processExpressionReduce.cntMinTermsInExpression(resultString);
        String[] currentMinTerms = new String[this.totalMinTerms];
        String[] currentMinTermsIDs = new String[this.totalMinTerms];
        String selectedRandComb = "";
        currentMinTerms = this.processExpressionReduce.generateMinTermsArray(resultString, this.totalMinTerms);
        int i = 0;
        while (i < currentMinTerms.length) {
            currentMinTermsIDs[i] = "M" + String.valueOf(i);
            ++i;
        }
        ArrayList<String> possibleCombinations = new ArrayList();
        possibleCombinations = this.generatePossibleCombs(currentMinTermsIDs);
        String[] randElandComb = new String[3];
        String matchedVariable = "";
        String loopReducedExpression = "";
        String lawReplace = "";
        int randCombIdx = 0;
        if (this.totalMinTerms > 1) {
            randCombIdx = this.selectRandMtCombId(possibleCombinations);
            if (this.manualSelComb) {
                randCombIdx = possibleCombinations.indexOf(this.manualComb);
            }
            randElandComb = this.obtainRandMt(possibleCombinations, randCombIdx, currentMinTerms);
            selectedRandComb = randElandComb[2];
            this.processRandElements = new FScanCommonLiterals(randElandComb[0], randElandComb[1]);
            this.processRandElements.executeScanCommonLiterals(randElandComb[0], randElandComb[1]);
            matchedVariable = this.processRandElements.getMatchedVar();
            String redRandElofMt0 = this.processRandElements.getRandRedEl1();
            String redRandElofMt1 = this.processRandElements.getRandRedEl2();
            ArrayList<String> separateArrayOfLitInMt0 = this.processRandElements.separateArrayOfLitInMt0;
            ArrayList<String> separateArrayOfLitInMt1 = this.processRandElements.separateArrayOfLitInMt1;
            boolean singleLitInMts = this.searchSingleLitInMt(separateArrayOfLitInMt0) && this.searchSingleLitInMt(separateArrayOfLitInMt1);
            lawReplace = "";
            String manRedRandElofMt0 = "";
            String manRedRandElofMt1 = "";
            if (singleLitInMts) {
                lawReplace = this.processExpressionReduce.scanRules(String.valueOf(separateArrayOfLitInMt0.get(0)) + "+" + separateArrayOfLitInMt1.get(0));
            } else {
                this.processRandElements.executeScanCommonLiterals(randElandComb[0], randElandComb[1]);
                matchedVariable = this.processRandElements.getMatchedVar();
                manRedRandElofMt0 = this.processRandElements.getRandRedEl1();
                manRedRandElofMt1 = this.processRandElements.getRandRedEl2();
                separateArrayOfLitInMt0 = this.processRandElements.separateArrayOfLitInMt0;
                separateArrayOfLitInMt1 = this.processRandElements.separateArrayOfLitInMt1;
            }
            loopReducedExpression = this.findReducedExpression(matchedVariable, manRedRandElofMt0, manRedRandElofMt1);
            if (!loopReducedExpression.isEmpty()) {
                lawReplace = loopReducedExpression;
            }
            if (!loopReducedExpression.isEmpty()) {
                lawReplace = this.replacedLaw(loopReducedExpression, matchedVariable);
            }
            ArrayList<String> nextMinterms = new ArrayList();
            if (lawReplace.length() != 0) {
                nextMinterms = this.deleteElFromMtArray(currentMinTerms, selectedRandComb);
                nextMinterms.add(lawReplace);
            } else {
                nextMinterms = new ArrayList<String>(Arrays.asList(currentMinTerms));
            }
            this.newExpression = "";
            this.newExpression = this.constructNewExpression(nextMinterms, this.newExpression);
            BCalculateCost newCost = new BCalculateCost(this.newExpression);
            this.costOfNewExpression = newCost.getCost();
        } else {
            this.newExpression = inputExpression;
            BCalculateCost newCost = new BCalculateCost(this.newExpression);
            this.costOfNewExpression = newCost.getCost();
        }
        this.outputExpression = this.newExpression;
        return this.outputExpression;
    }

    private void writeDataToFile(String data) throws Exception {
        this.writeText(data);
    }

    private void writeText(String data) throws IOException {
        FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.append(data);
        bw.newLine();
        bw.flush();
        bw.close();
    }

    private String constructNewExpression(ArrayList<String> nextMinterms, String newExpression) {
        int i = 0;
        while (i < nextMinterms.size()) {
            newExpression = nextMinterms.size() - i == 1 ? String.valueOf(newExpression) + nextMinterms.get(i) : String.valueOf(newExpression) + nextMinterms.get(i) + "+";
            ++i;
        }
        return newExpression;
    }

    private ArrayList<String> generatePossibleCombs(String[] minTermsIDs) {
        ArrayList<String> possibleCombinations = new ArrayList<String>();
        int i = 0;
        while (i < minTermsIDs.length) {
            int j = 0;
            while (j < minTermsIDs.length - (i + 1)) {
                possibleCombinations.add(minTermsIDs[i].concat(minTermsIDs[i + 1 + j]));
                ++j;
            }
            ++i;
        }
        return possibleCombinations;
    }

    private ArrayList<String> extractVariable(String inpExp) {
        BCalculateCost currentExpCost = new BCalculateCost(inpExp);
        int currentCost = currentExpCost.getCost();
        String literalsOnly = currentExpCost.getLiteralsOnly();
        ArrayList<String> variablesInExp = new ArrayList<String>();
        int i = 0;
        while (i < currentCost) {
            String var = literalsOnly.substring(i, i + 1);
            if (!variablesInExp.contains(var)) {
                variablesInExp.add(var);
            }
            ++i;
        }
        this.varCnt = variablesInExp.toArray().length;
        return variablesInExp;
    }

    private int selectRandMtCombId(ArrayList<String> possibleCombinations) {
        int randCombIdx = (int)Math.floor(Math.random() * (double)possibleCombinations.size());
        return randCombIdx;
    }

    private String[] obtainRandMt(ArrayList<String> possibleCombinations, int randCombIdx, String[] currentMinTerms) {
        String selectedRandComb = "";
        selectedRandComb = possibleCombinations.get(randCombIdx);
        String[] randIndices = selectedRandComb.substring(1).split("M", 2);
        String[] randElandComb = new String[randIndices.length + 1];
        int i = 0;
        while (i < randIndices.length) {
            randElandComb[i] = currentMinTerms[Integer.parseInt(randIndices[i])].replaceAll(" ", "");
            ++i;
        }
        randElandComb[2] = selectedRandComb;
        return randElandComb;
    }

    private boolean searchSingleLitInMt(ArrayList<String> separateArrayOfLitInMt) {
        if (separateArrayOfLitInMt.get(separateArrayOfLitInMt.size() - 1).isEmpty()) {
            separateArrayOfLitInMt.remove(separateArrayOfLitInMt.size() - 1);
        }
        boolean SingleLitInMt = separateArrayOfLitInMt.size() == 1;
        return SingleLitInMt;
    }

    private String findReducedExpression(String matchedVariable, String redRandElofMt0, String redRandElofMt1) {
        String initialReducedExpression = "";
        if (!matchedVariable.isEmpty()) {
            if (matchedVariable == redRandElofMt0 && redRandElofMt0 == redRandElofMt1) {
                initialReducedExpression = "";
            } else {
                initialReducedExpression = String.valueOf(matchedVariable) + "(" + redRandElofMt0 + "+" + redRandElofMt1 + ")";
                initialReducedExpression = initialReducedExpression.replaceAll(" ", "");
            }
        }
        return initialReducedExpression;
    }

    private String replacedLaw(String loopReducedExpression, String matchedVariable) {
        String intermediatte = loopReducedExpression.substring(matchedVariable.length());
        intermediatte = this.processExpressionReduce.replaceBracesWithTags(intermediatte);
        String[] afterSOPTag = this.processExpressionReduce.splitStringIntoTwo(intermediatte, "SOP1");
        intermediatte = intermediatte.contains("SOP1") ? afterSOPTag[1] : afterSOPTag[0];
        String[] beforeEOPTag = this.processExpressionReduce.splitStringIntoTwo(intermediatte, "EOP1");
        intermediatte = beforeEOPTag[0];
        int cntSubMinTerms = this.processExpressionReduce.cntMinTermsInExpression(intermediatte);
        String[] subMintermsArray = this.processExpressionReduce.generateMinTermsArray(intermediatte, cntSubMinTerms);
        String[] subMintermsIDs = new String[cntSubMinTerms];
        subMintermsIDs = this.genMintermIDs(subMintermsArray.length);
        ArrayList<String> subPossibleComb = this.generatePossibleCombs(subMintermsIDs);
        int i = 0;
        while (i < subMintermsArray.length) {
            intermediatte = this.processExpressionReduce.scanRules(subMintermsArray[i]);
            if (this.processExpressionReduce.ruleMatched) {
                loopReducedExpression = loopReducedExpression.replaceFirst(subMintermsArray[i], intermediatte);
            }
            subMintermsArray[i] = intermediatte;
            ++i;
        }
        boolean subElHasBrace = false;
        ArrayList<Integer> idxOfBrace = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < subMintermsArray.length) {
            if (subMintermsArray[i2].contains("(")) {
                subElHasBrace = true;
                idxOfBrace.add(i2);
            }
            ++i2;
        }
        if (subElHasBrace) {
            int i3 = 0;
            while (i3 < idxOfBrace.size()) {
                String subMinTermEl = subMintermsArray[(Integer)idxOfBrace.get(i3)];
                intermediatte = subMinTermEl.substring(subMinTermEl.indexOf("(") + 1);
                String toReplace = intermediatte.substring(0, intermediatte.indexOf(")"));
                String replacedRule = this.processExpressionReduce.scanRules(toReplace);
                String replacedLaw = !this.processExpressionReduce.ruleMatched ? subMinTermEl : this.rulesReplacer(subMinTermEl, toReplace, replacedRule);
                subMintermsArray[((Integer)idxOfBrace.get((int)i3)).intValue()] = replacedLaw;
                ++i3;
            }
            loopReducedExpression = this.subExpressionReducer(subMintermsArray, matchedVariable, subPossibleComb);
        } else {
            loopReducedExpression = this.subExpressionReducer(subMintermsArray, matchedVariable, subPossibleComb);
        }
        String lawReplace = "";
        if (loopReducedExpression.contains("(")) {
            String[] beforeBrace = this.processExpressionReduce.splitStringIntoTwo(loopReducedExpression, "(");
            if (beforeBrace[1].contains(")")) {
                String[] afterBrace = this.processExpressionReduce.splitStringIntoTwo(loopReducedExpression, "(");
                lawReplace = afterBrace[0] == "1" || afterBrace[0] == "0" || afterBrace[0] == "" ? loopReducedExpression.replace("(" + afterBrace[0] + ")", "") : loopReducedExpression;
            }
            lawReplace = loopReducedExpression;
        }
        lawReplace = loopReducedExpression;
        return lawReplace;
    }

    private String[] genMintermIDs(int numberOfMts) {
        String[] subMintermIDs = new String[numberOfMts];
        int i = 0;
        while (i < numberOfMts) {
            subMintermIDs[i] = "M" + String.valueOf(i);
            ++i;
        }
        return subMintermIDs;
    }

    private String subExpressionReducer(String[] subMintermsArray, String matchedVariable, ArrayList<String> subPossibleComb) {
        int idx = 0;
        String newExpression = "";
        ArrayList<Object> nextMinTermsArray = new ArrayList();
        String[] randElandComb = new String[]{"", "", ""};
        String matchedVar = "";
        do {
            String intermString;
            if (!subPossibleComb.isEmpty() && idx < subPossibleComb.size()) {
                randElandComb = this.obtainRandMt(subPossibleComb, idx, subMintermsArray);
            }
            String randComb = randElandComb[2];
            String randEl1 = this.processExpressionReduce.scanRules(randElandComb[0]);
            String randEl2 = this.processExpressionReduce.scanRules(randElandComb[1]);
            this.processRandElements.executeScanCommonLiterals(randElandComb[0], randElandComb[1]);
            String randRedEl1 = this.processRandElements.randRedEl1;
            String randRedEl2 = this.processRandElements.randRedEl2;
            matchedVar = this.processRandElements.matchedVar;
            newExpression = "";
            if (!matchedVar.isEmpty()) {
                newExpression = "";
                intermString = String.valueOf(randRedEl1) + "+" + randRedEl2;
                if ((intermString = this.processExpressionReduce.scanRules(intermString)).length() > 2) {
                    intermString = "(intermString)";
                } else if (intermString.equals("1")) {
                    intermString = "";
                }
                intermString = !intermString.isEmpty() ? String.valueOf(matchedVar) + intermString : matchedVar;
                intermString = this.processExpressionReduce.scanRules(intermString);
                nextMinTermsArray = this.deleteElFromMtArray(subMintermsArray, randComb);
                nextMinTermsArray.add(intermString);
                idx = 0;
                newExpression = this.createNewExp(newExpression, nextMinTermsArray);
                subMintermsArray = nextMinTermsArray.toArray(new String[nextMinTermsArray.size()]);
                subPossibleComb = this.generatePossibleCombs(this.genMintermIDs(nextMinTermsArray.size()));
                continue;
            }
            intermString = this.processExpressionReduce.scanRules(String.valueOf(randEl1) + "+" + randEl2);
            if (this.processExpressionReduce.ruleMatched) {
                nextMinTermsArray = this.deleteElFromMtArray(subMintermsArray, randComb);
                nextMinTermsArray.add(intermString);
                idx = 0;
                newExpression = this.createNewExp(newExpression, nextMinTermsArray);
                subMintermsArray = nextMinTermsArray.toArray(new String[nextMinTermsArray.size()]);
                subPossibleComb = this.generatePossibleCombs(this.genMintermIDs(nextMinTermsArray.size()));
                continue;
            }
            newExpression = "";
            nextMinTermsArray = new ArrayList<String>(Arrays.asList(subMintermsArray));
            newExpression = this.createNewExp(newExpression, nextMinTermsArray);
            idx = 0;
        } while (subPossibleComb.size() - 1 != idx && !subPossibleComb.isEmpty());
        newExpression = !newExpression.equals("1") ? String.valueOf(matchedVariable) + "(" + newExpression + ")" : matchedVariable;
        return newExpression;
    }

    private ArrayList<String> deleteElFromMtArray(String[] subMintermsArray, String randComb) {
        ArrayList<String> nextMinTermsArray = new ArrayList<String>(Arrays.asList(subMintermsArray));
        nextMinTermsArray.remove(Integer.parseInt(randComb.substring(3)));
        nextMinTermsArray.remove(Integer.parseInt(randComb.substring(1, randComb.length() - 2)));
        return nextMinTermsArray;
    }

    private String createNewExp(String newExpression, ArrayList<String> nextMinTermsArray) {
        int i = 0;
        while (i < nextMinTermsArray.size()) {
            newExpression = nextMinTermsArray.size() - i == 1 ? String.valueOf(newExpression) + nextMinTermsArray.get(i) : String.valueOf(newExpression) + nextMinTermsArray.get(i) + "+";
            ++i;
        }
        return newExpression;
    }

    private String rulesReplacer(String lawToReplace, String toReplace, String replacedRule) {
        String intermString = lawToReplace.replaceFirst(toReplace, replacedRule);
        int idx = intermString.indexOf(replacedRule);
        intermString = intermString.replace(intermString.charAt(idx - 1), ' ');
        idx = intermString.indexOf(replacedRule);
        intermString = intermString.replace(intermString.charAt(idx + replacedRule.length()), ' ');
        String replacedLaw = replacedRule == "0" || replacedRule == "1" ? intermString.replaceFirst(replacedRule, " ") : intermString;
        return replacedLaw;
    }
}

