/*
 * Decompiled with CFR 0.152.
 */
package LogicOptimization;

import java.util.Scanner;
import java.util.regex.Pattern;

public class ALVJavaInterface {
    public static String origInputEq;
    public String[] origInputNames;
    public String newInputEq;
    public String[] newInputNames;
    public static double tempCoeff;
    public static double initTemp;
    public static double timeToRun;

    public ALVJavaInterface() {
        this.origInputNames = this.origInputNames;
    }

    public String getOrigInputEq() {
        return origInputEq;
    }

    public static void setOrigInputEq(String origInputEq) {
    }

    public String[] getOrigInputNames() {
        return this.origInputNames;
    }

    public void setOrigInputNames(String[] origInputNames) {
        this.origInputNames = origInputNames;
    }

    public String getNewInputEq() {
        return this.newInputEq;
    }

    public void setNewInputEq(String newInputEq) {
        this.newInputEq = newInputEq;
    }

    public String[] replaceInputNames() {
        int size = this.origInputNames.length;
        String[] newInputNames = new String[size];
        int i = 0;
        while (i < size) {
            char in = (char)(i + 97);
            newInputNames[i] = Character.toString(in);
            ++i;
        }
        this.newInputNames = newInputNames;
        return newInputNames;
    }

    public String replaceInputEqWithNewNames(String[] newInputNames) {
        String newInputEq = "";
        newInputEq = origInputEq;
        int i = 0;
        while (i < this.origInputNames.length) {
            String currentInput = this.origInputNames[i];
            String newInput = newInputNames[i];
            newInputEq = newInputEq.replaceAll(currentInput, newInput);
            ++i;
        }
        newInputEq = newInputEq.replaceAll(" ", "");
        newInputEq = newInputEq.replaceAll("\\.", "");
        return newInputEq;
    }

    public String[] getNewInputNames() {
        return this.newInputNames;
    }

    public String replaceInputEqWithOrigNames(String inputEquation, String[] newInputNames, String[] origInputNames) {
        String newOrigEq = "";
        newOrigEq = inputEquation;
        int i = 0;
        while (i < origInputNames.length) {
            String currentInput = origInputNames[i];
            String newInput = newInputNames[i];
            newOrigEq = newOrigEq.replaceAll("\\b" + newInput + "\\b", currentInput);
            ++i;
        }
        newOrigEq = newOrigEq.replaceAll(" ", "");
        newOrigEq = newOrigEq.replaceAll("\\.", "");
        return newOrigEq;
    }

    public static void takeInputs() {
        Scanner userInputs = new Scanner(System.in);
        System.out.println("*********** Please enter the following values ***********");
        while (true) {
            System.out.print("Temperature Coefficient (e.g. 0.9). => ");
            try {
                tempCoeff = userInputs.nextDouble();
            }
            catch (Exception e) {
                System.out.print("You have entered a wrong value. Please try again. \n\n");
                userInputs.next();
                continue;
            }
            break;
        }
        while (true) {
            System.out.print("Initial Temperature (e.g. 10). => ");
            try {
                initTemp = userInputs.nextDouble();
            }
            catch (Exception e) {
                System.out.print("You have entered a wrong value. Please try again. \n\n");
                userInputs.next();
                continue;
            }
            break;
        }
        while (true) {
            System.out.print("Time to run in seconds (e.g. 0.5 secs). => ");
            try {
                timeToRun = userInputs.nextDouble();
            }
            catch (Exception e) {
                System.out.print("You have entered a wrong value. Please try again. \n\n");
                userInputs.next();
                continue;
            }
            break;
        }
        while (true) {
            System.out.print("Enter boolean expression in terms of inputs IPTG, aTc and Arabinose. \n(Use \" ' \" for inverted terms; \" . \" for ANDed terms; and \" + \" for ORed terms, without any spaces.) \n(e.g. IPTG'.aTc.Arabinose'+IPTG'.aTc.Arabinose+IPTG.aTc.Arabinose) \n=> ");
            try {
                String inpBoolExpression = userInputs.next();
                if (inpBoolExpression.matches("[a-zA-Z' +.]+")) {
                    if (Pattern.compile("^(\\w).*[\\w']$").matcher(inpBoolExpression).find()) {
                        origInputEq = inpBoolExpression;
                        System.out.print("X-------------------------------X-------------------------------X \n\n");
                        break;
                    }
                    System.out.print("Invalid Expression! Please try again below. \n\n");
                    continue;
                }
                System.out.print("The input expression contains invalid characters. Please try again below. \n\n");
            }
            catch (Exception e) {
                System.out.print("You have entered a wrong expression. Please try again below. \n\n");
                userInputs.next();
            }
        }
        System.out.println("");
    }
}

