/*
 * $Id: IFormulaParser.java 1760 2014-05-29 12:09:37Z niko-rodrigue $
 * $URL: svn+ssh://niko-rodrigue@svn.code.sf.net/p/jsbml/code/trunk/core/src/org/sbml/jsbml/text/parser/IFormulaParser.java $
 * ----------------------------------------------------------------------------
 * This file is part of JSBML. Please visit <http://sbml.org/Software/JSBML>
 * for the latest version of JSBML and more information about SBML.
 *
 * Copyright (C) 2009-2014 jointly by the following organizations:
 * 1. The University of Tuebingen, Germany
 * 2. EMBL European Bioinformatics Institute (EBML-EBI), Hinxton, UK
 * 3. The California Institute of Technology, Pasadena, CA, USA
 * 4. The University of California, San Diego, La Jolla, CA, USA
 * 5. The Babraham Institute, Cambridge, UK
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation. A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as <http://sbml.org/Software/JSBML/License>.
 * ----------------------------------------------------------------------------
 */
package org.sbml.jsbml.text.parser;

import java.io.InputStream;
import java.io.Reader;

import org.sbml.jsbml.ASTNode;

/**
 * An interface for the FormulaParser generated by JavaCC to parse infix math formula.
 * <p>
 * This allow users of jsbml to develop easily their own formula parser and pass it to the 
 * {@link ASTNode#parseFormula(String, IFormulaParser)} method.
 * 
 * @author Nicolas Rodriguez
 * @version $Rev: 1760 $
 * @since 1.0
 */
public interface IFormulaParser {

	public void ReInit(Reader stream);
	
	// public void ReInit(FormulaParserTokenManager tm);
	
	public void ReInit(InputStream stream, String encoding);
	
	public void ReInit(InputStream stream);
	
	public ASTNode parse() throws ParseException;
}
